/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package simplekidcalc;

//import javax.swing.SwingWorker;

import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;







public class FrontFrame extends javax.swing.JFrame {

    SimpleKidCalc instanceOfSimpleKidCalc = new SimpleKidCalc(5,5,2);
    private int calcRunning = 0;
    private long userAnswer = 0;
    private int hits = 0;
    private int misses = 0;
    long tStart; // = System.currentTimeMillis();
    long tDelta; // = System.currentTimeMillis() - tStart;
    double elapsedSeconds; // = tDelta / 1000.0;
                     
    
    //here I need to make a something when it starts
    private void updateLabels(){
        jlbl_topTerm.setText(Integer.toString(instanceOfSimpleKidCalc.getTop_number()));
        jlbl_bottomTerm.setText(Integer.toString(instanceOfSimpleKidCalc.getBottom_number()));
        jlbl_HITS.setText(Integer.toString(hits));
        jlbl_MISSES.setText(Integer.toString(misses));
        jtxtFld_ANS.setText("");
        jtxtFld_ANS.setEnabled(true);
        tStart = System.currentTimeMillis();
    }
    
    private void updateOperator(){
        jlbl_operation.setText(instanceOfSimpleKidCalc.getOptMode());
    }
    
    public void showAnswer(){
        jlbl_topTerm.setText("ANSWER");
        if (instanceOfSimpleKidCalc.getOptMode().equals("/")){
        jlbl_bottomTerm.setText(Long.toString(instanceOfSimpleKidCalc.getAnswer())+ " rm " + Long.toString(instanceOfSimpleKidCalc.getRemainderToAnswer()));    
        }else{
        jlbl_bottomTerm.setText(Long.toString(instanceOfSimpleKidCalc.getAnswer()));
        jtxtFld_ANS.setEnabled(false);
        }
        jlbl_TIME.setText(Double.toString(elapsedSeconds)+"s");
    }
    
    
    
    /**
     * Creates new form FrontFrame
     */
    public FrontFrame() {
        initComponents();
        this.getRootPane().setDefaultButton(jBtn_next); //I added this, was not automatically generated
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jRB_yes = new javax.swing.JRadioButton();
        jRB_no = new javax.swing.JRadioButton();
        jBtn_next = new javax.swing.JButton();
        jRB_addition = new javax.swing.JRadioButton();
        jRB_subtraction = new javax.swing.JRadioButton();
        jRB_multiplication = new javax.swing.JRadioButton();
        jRB_division = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jtxtFld_ANS = new javax.swing.JTextField();
        jlbl_bottomTerm = new javax.swing.JLabel();
        jlbl_operation = new javax.swing.JLabel();
        jlbl_topTerm = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jLabel4 = new javax.swing.JLabel();
        jProgressBar = new javax.swing.JProgressBar();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jlbl_HITS = new javax.swing.JLabel();
        jlbl_MISSES = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jlbl_TIME = new javax.swing.JLabel();
        lblAbout = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Simple Kid Calc Math Game");
        setBackground(new java.awt.Color(0, 204, 255));
        setForeground(new java.awt.Color(51, 153, 255));
        setResizable(false);

        buttonGroup1.add(jRB_yes);
        jRB_yes.setText("yes");
        jRB_yes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRB_yesActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRB_no);
        jRB_no.setSelected(true);
        jRB_no.setText("no");
        jRB_no.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRB_noActionPerformed(evt);
            }
        });

        jBtn_next.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jBtn_next.setText("NEXT");
        jBtn_next.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtn_nextActionPerformed(evt);
            }
        });

        buttonGroup2.add(jRB_addition);
        jRB_addition.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        jRB_addition.setSelected(true);
        jRB_addition.setText("+");
        jRB_addition.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRB_additionActionPerformed(evt);
            }
        });

        buttonGroup2.add(jRB_subtraction);
        jRB_subtraction.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        jRB_subtraction.setText("-");
        jRB_subtraction.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRB_subtractionActionPerformed(evt);
            }
        });

        buttonGroup2.add(jRB_multiplication);
        jRB_multiplication.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        jRB_multiplication.setText("x");
        jRB_multiplication.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRB_multiplicationActionPerformed(evt);
            }
        });

        buttonGroup2.add(jRB_division);
        jRB_division.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        jRB_division.setText("/");
        jRB_division.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRB_divisionActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel1.setText("Allow negavties");

        jLabel2.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel2.setText("Operation Type");

        jLabel3.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        jLabel3.setText("Level");

        jtxtFld_ANS.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jtxtFld_ANS.setHorizontalAlignment(javax.swing.JTextField.CENTER);

        jlbl_bottomTerm.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jlbl_bottomTerm.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlbl_bottomTerm.setText("00000000000");

        jlbl_operation.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jlbl_operation.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlbl_operation.setText("OPT");

        jlbl_topTerm.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jlbl_topTerm.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlbl_topTerm.setText("00000000000");

        jSlider1.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jSlider1.setMajorTickSpacing(1);
        jSlider1.setMaximum(10);
        jSlider1.setMinimum(1);
        jSlider1.setPaintLabels(true);
        jSlider1.setPaintTicks(true);
        jSlider1.setSnapToTicks(true);
        jSlider1.setToolTipText("");
        jSlider1.setValue(2);
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });

        jLabel4.setFont(new java.awt.Font("Avignon", 0, 18)); // NOI18N
        jLabel4.setForeground(new java.awt.Color(0, 153, 204));
        jLabel4.setText("Simple Kid Calc Math Game");

        jLabel5.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel5.setText("Points");

        jLabel6.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel6.setText("Hits");

        jLabel7.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel7.setText("Misses");

        jlbl_HITS.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jlbl_HITS.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlbl_HITS.setText("0");
        jlbl_HITS.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);

        jlbl_MISSES.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jlbl_MISSES.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlbl_MISSES.setText("0");
        jlbl_MISSES.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);

        jLabel10.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel10.setText("Elapsed Time");
        jLabel10.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);

        jlbl_TIME.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        jlbl_TIME.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlbl_TIME.setText("0.0s");
        jlbl_TIME.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);

        lblAbout.setForeground(new java.awt.Color(102, 102, 102));
        lblAbout.setText("About");
        lblAbout.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblAboutMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel4)
                        .addGap(101, 101, 101)
                        .addComponent(jLabel5)
                        .addGap(76, 76, 76))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(10, 10, 10)
                                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 282, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(33, 33, 33)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jtxtFld_ANS, javax.swing.GroupLayout.PREFERRED_SIZE, 219, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jlbl_operation)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jlbl_topTerm, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(jlbl_bottomTerm, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jRB_yes)
                                .addGap(18, 18, 18)
                                .addComponent(jRB_no))
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jLabel2)
                                .addComponent(jBtn_next)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jRB_multiplication)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(jRB_division))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jRB_addition)
                                        .addGap(18, 18, 18)
                                        .addComponent(jRB_subtraction))))
                            .addComponent(jLabel1))
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(71, 71, 71)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                                    .addComponent(jLabel6)
                                    .addComponent(jlbl_HITS))
                                .addGap(56, 56, 56)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                                    .addComponent(jLabel7)
                                    .addComponent(jlbl_MISSES))
                                .addGap(33, 33, 33))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addGap(52, 52, 52)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel10)
                                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                        .addComponent(jlbl_TIME)
                                        .addGap(19, 19, 19)))
                                .addGap(55, 55, 55)))))
                .addGap(0, 0, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(jProgressBar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(lblAbout)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel5))
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel4)
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(40, 40, 40)
                        .addComponent(jlbl_topTerm)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jlbl_operation)
                            .addComponent(jlbl_bottomTerm))
                        .addGap(11, 11, 11)
                        .addComponent(jtxtFld_ANS, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jRB_yes)
                                    .addComponent(jRB_no))
                                .addGap(45, 45, 45)
                                .addComponent(jLabel2))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(8, 8, 8)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jLabel6)
                                        .addGap(18, 18, 18)
                                        .addComponent(jlbl_HITS))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jLabel7)
                                        .addGap(18, 18, 18)
                                        .addComponent(jlbl_MISSES)))))
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addGroup(layout.createSequentialGroup()
                                    .addGap(52, 52, 52)
                                    .addComponent(jlbl_TIME))
                                .addComponent(jLabel10, javax.swing.GroupLayout.Alignment.LEADING))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jRB_addition)
                                    .addComponent(jRB_subtraction))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jRB_multiplication)
                                    .addComponent(jRB_division))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jBtn_next, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                .addGap(18, 18, 18)
                .addComponent(jProgressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblAbout)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jRB_yesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRB_yesActionPerformed
        instanceOfSimpleKidCalc.setNegAllowed(1);
    }//GEN-LAST:event_jRB_yesActionPerformed

    private void jRB_additionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRB_additionActionPerformed
        instanceOfSimpleKidCalc.setOptMode("+");
    }//GEN-LAST:event_jRB_additionActionPerformed

    private void jBtn_nextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtn_nextActionPerformed
        // TODO add your handling code here:
        
        
        if (calcRunning == 1){
            //check if there is a number there
            
          if (!jtxtFld_ANS.getText().isEmpty()){
            try {
               userAnswer = Long.valueOf(jtxtFld_ANS.getText());
               if (userAnswer == instanceOfSimpleKidCalc.getAnswer()){ 
                   jProgressBar.setValue(jProgressBar.getValue()+1); ++hits;
               }else{ ++misses; }
                    //long tEnd = System.currentTimeMillis();
                    tDelta = System.currentTimeMillis() - tStart;
                    elapsedSeconds = tDelta / 1000.0;                    
                    calcRunning = 0;
                    showAnswer();
               //instanceOfSimpleKidCalc.getSomeNumbers();
            } catch (Exception e) {
                //System.err.println("Caught IOException: " + e.getMessage());
                //just do nothing
            }
          }else{
              calcRunning = 0;
              showAnswer();
          }//

        }else{
            //make new question
            instanceOfSimpleKidCalc.getSomeNumbers();
            updateLabels();
            updateOperator();
            calcRunning = 1; 
            jtxtFld_ANS.grabFocus();
        }
        
      

        
        
        
        
        
        
    }//GEN-LAST:event_jBtn_nextActionPerformed

    private void jRB_noActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRB_noActionPerformed
        instanceOfSimpleKidCalc.setNegAllowed(0);
    }//GEN-LAST:event_jRB_noActionPerformed

    private void jRB_subtractionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRB_subtractionActionPerformed
        instanceOfSimpleKidCalc.setOptMode("-");
    }//GEN-LAST:event_jRB_subtractionActionPerformed

    private void jRB_multiplicationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRB_multiplicationActionPerformed
        instanceOfSimpleKidCalc.setOptMode("X");
    }//GEN-LAST:event_jRB_multiplicationActionPerformed

    private void jRB_divisionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRB_divisionActionPerformed
        instanceOfSimpleKidCalc.setOptMode("/");
    }//GEN-LAST:event_jRB_divisionActionPerformed

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged
        instanceOfSimpleKidCalc.setLevel(jSlider1.getValue());
    }//GEN-LAST:event_jSlider1StateChanged

    private void lblAboutMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblAboutMouseClicked
        Gpl license = new Gpl();
        //JOptionPane.showMessageDialog(jOptionPane,license.Text);

        JTextArea textArea = new JTextArea(license.Text);
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        scrollPane.setPreferredSize( new Dimension( 500, 500 ) );
        JOptionPane.showMessageDialog(null, scrollPane);
    }//GEN-LAST:event_lblAboutMouseClicked

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrontFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrontFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrontFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrontFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new FrontFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton jBtn_next;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JProgressBar jProgressBar;
    private javax.swing.JRadioButton jRB_addition;
    private javax.swing.JRadioButton jRB_division;
    private javax.swing.JRadioButton jRB_multiplication;
    private javax.swing.JRadioButton jRB_no;
    private javax.swing.JRadioButton jRB_subtraction;
    private javax.swing.JRadioButton jRB_yes;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JLabel jlbl_HITS;
    private javax.swing.JLabel jlbl_MISSES;
    private javax.swing.JLabel jlbl_TIME;
    private javax.swing.JLabel jlbl_bottomTerm;
    private javax.swing.JLabel jlbl_operation;
    private javax.swing.JLabel jlbl_topTerm;
    private javax.swing.JTextField jtxtFld_ANS;
    private javax.swing.JLabel lblAbout;
    // End of variables declaration//GEN-END:variables
}
